---
generated_at: 2026-02-04 11:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-History Server

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全Claimに根拠あり。特記事項なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/deploy/history/HistoryServer.scala`（全文読取済み）
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（全文読取済み）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（全文読取済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 完了済みアプリのSparkUIを再構築 | E-01 (39-48行 コメント) | ○ |
| C-02 | UIパスプレフィックスは"/history" | E-01 (302行) | ○ |
| C-03 | loaderServletでアプリ動的ロード | E-01 (77-132行) | ○ |
| C-04 | ApplicationCacheでLRUキャッシュ管理 | E-01 (72行) | ○ |
| C-05 | retainedApplicationsでキャッシュサイズ制限 | E-01 (66行) | ○ |
| C-06 | maxApplicationsで一覧表示制限 | E-01 (69行) | ○ |
| C-07 | 複数Attempt対応（リダイレクト） | E-01 (91-101行) | ○ |
| C-08 | TRACEメソッド拒否（SPARK-5983） | E-01 (129-131行) | ○ |
| C-09 | poolSize=1000の設定 | E-01 (60行) | ○ |
| C-10 | createSecurityManagerでspark.authenticateをfalse化 | E-01 (335-339行) | ○ |
| C-11 | Kerberos認証対応 | E-01 (350-361行) | ○ |
| C-12 | Kerberos設定欠落時にNoSuchElementException | E-01 (358-360行) | ○ |
| C-13 | ShutdownHookManagerによる停止処理 | E-01 (322行) | ○ |
| C-14 | writeEventLogs ZIPダウンロード | E-01 (236-241行) | ○ |
| C-15 | 画面No.28,29との関連 | E-02 (91行,96行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全Claimに根拠あり、低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] FsHistoryProvider.scalaの定期スキャンロジックを確認
- [ ] ApplicationCache.scalaのLRU実装詳細を確認
- [ ] HistoryPage.scalaの一覧表示ロジックを確認
